import sys
import codecs
def is_sub(a, b):
    i = 0
    n = len(b)
    for c in a:
        while i < n and b[i] != c:
            i += 1
        if i >= n:
            return False
        i += 1
    return True

def is_password(p : str) -> bool:
    l = len(p)
    if l % 2 == 1:
        return False
    for i in range(l//2):
        if (i & 1) == 1:
            if p[i] == p[-i - 1]:
                return False
        else:
            if p[i] != p[-i - 1]:
                return False
    return True

if sys.stderr.encoding != 'UTF-8':
	sys.stderr = codecs.getwriter('utf-8')(sys.stderr.buffer, 'strict')

def msg(p, s):
	print(p)
	sys.stderr.write(s)

def wrong(s):
	msg(0, f"Wrong answer. {s}!\n")
	exit(0)

def ok(s):
	msg(100, f"Accepted. {s}!\n")
	exit(0)

inf = open("input", "r")
n = inf.readline().strip()
s = inf.readline().strip()

ouf = open("user_out", "r")
p = ouf.readline().strip()

ans = open('answer', 'r')
t = ans.readline().strip()

if len(p) < len(t):
    wrong('Độ dài xâu của bạn không thỏa')

if not is_sub(p, s):
    wrong('Mật khẩu của bạn không phải xâu con của xâu S')

if not is_password(p):
    wrong("Xâu của bạn không phải là mật khẩu")

if len(p) > len(t):
    ok("Ơ mây zing gút chóp em. Em đúng là thiên tài vì tìm được xâu mật khẩu dài hơn cả đáp án")
elif p < t:
    ok("Ơ mây zing gút chóp em. Em đúng là thiên tài vì tìm được xâu mật khẩu có thứ tự từ điển nhỏ hơn đáp án")
elif p == t:
    ok("Ơ mây zing gút chóp em")
else:
    msg(30, "Xâu của bạn có thứ tự từ điển lớn hơn đáp án")