from functools import wraps
import sys
import codecs

if sys.stderr.encoding != 'UTF-8':
	sys.stderr = codecs.getwriter('utf-8')(sys.stderr.buffer, 'strict')

def msg(p, s):
	print(p)
	sys.stderr.write(s)

def wrong(s):
	msg(0, f"Wrong answer. {s}!\n")
	exit(0)

def ok(s):
	msg(100, f"Accepted. {s}!\n")
	exit(0)

ans = open('answer', 'r')
_ans = ans.readline().strip().upper()
ouf = open("user_out", "r")
_out = ouf.readline().strip().upper()

if (_ans != _out):
    wrong(f"Đáp án: {_ans}, Bạn: {_out}")
else:
    ok(u"Ơ mây zing, gút chóp em")