#include <bits/stdc++.h>
#include "testlib.h"
#define double long double
using namespace std;

template <class T> int sgn(T x) { return (x > 0) - (x < 0); }
template<class T>
struct Point {
	typedef Point P;
	T x, y;
	explicit Point(T x=0, T y=0) : x(x), y(y) {}
	bool operator<(P p) const { return tie(x,y) < tie(p.x,p.y); }
	bool operator==(P p) const { return tie(x,y)==tie(p.x,p.y); }
	P operator+(P p) const { return P(x+p.x, y+p.y); }
	P operator-(P p) const { return P(x-p.x, y-p.y); }
	P operator*(T d) const { return P(x*d, y*d); }
	P operator/(T d) const { return P(x/d, y/d); }
	T dot(P p) const { return x*p.x + y*p.y; }
	T cross(P p) const { return x*p.y - y*p.x; }
	T cross(P a, P b) const { return (a-*this).cross(b-*this); }
	T dist2() const { return x*x + y*y; }
	double dist() const { return sqrt((double)dist2()); }
	// angle to x-axis in interval [-pi, pi]
	double angle() const { return atan2(y, x); }
	P unit() const { return *this/dist(); } // makes dist()=1
	P perp() const { return P(-y, x); } // rotates +90 degrees
	P normal() const { return perp().unit(); }
	// returns point rotated 'a' radians ccw around the origin
	P rotate(double a) const {
		return P(x*cos(a)-y*sin(a),x*sin(a)+y*cos(a)); }
	friend ostream& operator<<(ostream& os, P p) {
		return os << "(" << p.x << "," << p.y << ")"; }
};

typedef Point<double> P;

int x[4],y[4];
double r[4];
const double eps = 1e-4;

inline double readAndCheckAnswer(InStream& in) {
    double X = in.readDouble();
    double Y = in.readDouble();
    
	double angle1 = atan(r[1]/(P(X,Y)-P(x[1],y[1])).dist());
    double angle2 = atan(r[2]/(P(X,Y)-P(x[2],y[2])).dist());
    double angle3 = atan(r[3]/(P(X,Y)-P(x[3],y[3])).dist());
    
    if (abs(angle1-angle2)<eps and abs(angle2-angle3)<eps)
		return angle1;
	else
		return -1;
}

int main(int argc, char* argv[]) {
    registerTestlibCmd(argc, argv);

	for (int i=1; i<=3; i++)
	{
		x[i] = inf.readInt();
		y[i] = inf.readInt();
		r[i] = inf.readInt();
	}
	
    double ja = readAndCheckAnswer(ans);
    double pa = readAndCheckAnswer(ouf);

	if (abs(ja-pa)<eps)
		quitf(_ok, "Accepted");
	else
		quitf(_wa, "Wrong Answer");
}

