#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Dap an duoc chap nhan!\n");
}

struct DSU {
    int n;
    vector<int> par;
    DSU() : n(0) {}
    DSU(int n) : n(n) {
        par = vector<int> (n + 1, -1);
    }
    int root(int u) {
        if (par[u] < 0) return u;
        return par[u] = root(par[u]);
    }
    void _union(int u, int v) {
        int ru = root(u), rv = root(v);
        if (ru == rv) return;
        if (par[ru] < par[rv])
            swap(ru, rv);
        par[rv] += par[ru];
        par[ru] = rv;
    }
    bool isjoint(int u, int v) {
        return root(u) == root(v);
    }
};
typedef vector<int> vti;
typedef vector<vti> vtp;
vtp dsk;
DSU d;
int n, m;
bool check(int u, int v) {
    if (u < 1 || u > n || v < 1 || v > n) return 0;
    if (v < u) swap(u, v);
    bool ok = 0;
    for (int x : dsk[u])
        if (x == v) {
            ok = 1;
            break;
        }
    if (!ok)
        return 0;
    if (d.isjoint(u, v))
        return 0;
    d._union(u, v);
    return 1;
}

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    inf >> n >> m;
    d = DSU(n);
    dsk = vtp(n + 1, vti(0));
    int u, v;
    while (m--) {
        inf >> u >> v;
        if (v < u)
            swap(u, v);
        dsk[u].push_back(v);
    }
    for (int i = 1; i < n; i++) {
        if (!(ouf >> u >> v))
            waf("Sai. Du lieu ra khong dung dinh dang!\n");
        if (!check(u, v))
            waf("Sai. Canh (%d, %d) sai!\n", u, v);
    }
    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
