#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
#define nmax 201

void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Dap an duoc chap nhan!\n");
}

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    bool a[nmax][nmax];
    bool visited[nmax];
    int n, s, prev = -1, u, v;
    string as, os;
    ans >> as;
    if (!(ouf >> os))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");

    if (as != os) {
        if (as == "NO")
            waf("Sai. Khong co duong di thoa man!\n");
        else
            waf("Sai. Co duong di thoa man!\n");
    }
    if (as == "NO") {
        OK(ouf, waf);
        return 1;
    }

    inf >> n >> s;
    memset(a, 0, sizeof a);
    while (inf >> u >> v)
        a[u][v] = a[v][u] = 1;

    memset(visited, 0, sizeof visited);

    while (ouf >> u) {
        if (u < 1 || u > n)
            waf("Sai. Dinh %d khong dung!\n", u);

        if (prev == -1) {
            if (u != s)
                waf("Sai. Duong di khong xuat phat tu %d!\n", s);
            prev = u;
            visited[u] = 1;
        } else {
            if (!a[prev][u])
                waf("Sai. Khong co duong di tu %d den %d!\n", prev, u);
            if (u == s) {
                OK(ouf, waf);
                return 1;
            }
            if (visited[u])
                waf("Sai. Dinh %d da tham!\n", u);
            visited[u] = 1;
            a[prev][u] = 0;
            prev = u;
        }
    }
    waf("Sai. Duong di khong quay ve %d!\n", s);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
