#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
#define nmax 50
int c[nmax][nmax],preV = -1, n, fee = 0;
bool f[nmax];

bool check(int v) {
    if (v < 1 || v > n) return 0;
	if (preV < 0) {
        if (v != 1) return 0;
        preV = 1;
        return 1;
	}
    if (f[v]) return 0;
    f[v] = 1;
    fee += c[preV][v];
    preV = v;
    return 1;
}
bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    int a_fee, o_fee, v;
    if (!(ouf >> o_fee))
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    ans >> a_fee;
    if (a_fee != o_fee)
        waf("Sai. Chi phi toi thieu khong dung. Dap an dung la %d.\n", a_fee);

    inf >> n;
    for (int i = 1; i <= n; i++)
        for (int j = 1; j <= n; j++)
            inf >> c[i][j];
    memset(f, 0, sizeof f);
    for (int i = 0; i <= n; i++) {
        if (!(ouf >> v))
            waf("Sai. Du lieu ra khong dung dinh dang.\n");
        if (!check(v))
            waf("Sai. Hanh trinh khong dung.\n");
    }
    if (v != 1 || fee != a_fee)
        waf("Sai. Hanh trinh khong dung.\n");

    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Hanh trinh voi chi phi toi thieu la %d!\n", a_fee);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
