#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
#define nmax 50
int a[nmax][nmax];
int m, n, preX = -1, preY, x, y, s = 0, as;

bool check(int x, int y) {
    if (x < 1 || x > n || y < 1 || y > m) return 0;
    if (a[y][x] < 0)
        return 0;
    if (preX == -1) {
        if (x != 1 || y != 1)
            return 0;
        preX = x; preY = y;
        s += a[y][x];
        return 1;
    }
    if (x < preX || y < preY || (x - preX) + (y - preY) != 1) return 0;
    s += a[y][x];
    preX = x; preY = y;
    return 1;
}
bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    ans >> as;
    if (!(ouf >> s))
        waf("Sai. Du lieu ra khong dung dinh dang.\n");

    if (as != s) {
        if (as == -1)
            waf("Sai. Khong co duong di thoa man.\n");
        else
            waf("Sai. Bo hoa dep nhat la %d.\n", as);
    }
    if (as == -1) {
        judge_message("OK. Khong co duong di thoa man.\n");
        return 1;
    }
    s = 0;
    inf >> m >> n;
    for (int i = 1; i <= m; i++)
        for (int j = 1; j <= n; j++)
            inf >> a[i][j];

    for (int i = 1; i <= n + m  - 1; i++) {
        if (!(ouf >> y >> x))
            waf("Sai. Du lieu ra khong dung dinh dang.");
        if (!check(x, y))
            waf("Sai. Duong di khong dung.\n");
    }
    if (s < as)
        waf("Sai. Bo hoa dep nhat la %d.\n", as);
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Bo hoa dep nhat la %d.\n", as);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
