#ifdef THEMIS
#include "testlib_themis.h"
const std::string TASK_NAME = "CLASSSCH";
#define _100 1.0
#else
#include "testlib.h"
#define _100 100.0
#endif // THEMIS

#include <bits/stdc++.h>
using namespace std;

int n, m;
vector<pair<int, int>> prereq;

void readInput() {
    n = inf.readInt();
    m = inf.readInt();
    prereq.clear();
    for (int i = 0; i < m; ++i) {
        int a = inf.readInt(1, n);
        int b = inf.readInt(1, n);
        if (a == b) quitf(_fail, "Self-loop detected in input");
        prereq.emplace_back(a, b);
    }
}

vector<int> readOrder(InStream &stream, bool &impossible) {
    string first = stream.readToken();
    if (first == "IMPOSSIBLE") {
        impossible = true;
        return vector<int>();
    }
    impossible = false;
    vector<int> order(n);
    order[0] = stoi(first);
    for (int i = 1; i < n; ++i) {
        order[i] = stream.readInt(1, n);
    }
    return order;
}

bool isValidOrder(const vector<int> &order) {
    if ((int)order.size() != n) return false;
    vector<int> pos(n + 1, -1);
    for (int i = 0; i < n; ++i) {
        int v = order[i];
        if (v < 1 || v > n) return false;
        if (pos[v] != -1) return false; // duplicate
        pos[v] = i;
    }
    for (auto [a, b] : prereq) {
        if (pos[a] > pos[b]) return false;
    }
    return true;
}

void readOutput() {
    bool ansImpossible = false, outImpossible = false;
    vector<int> ansOrder = readOrder(ans, ansImpossible);
    vector<int> outOrder = readOrder(ouf, outImpossible);
    if (ansImpossible) {
        if (!outImpossible) {
            quitf(_wa, "Expected IMPOSSIBLE, but contestant output is a valid order");
        }
        quitf(_ok, "Both outputs are IMPOSSIBLE");
    } else {
        if (outImpossible) {
            quitf(_wa, "Expected a valid order, but contestant output is IMPOSSIBLE");
        }
        if (!isValidOrder(outOrder)) {
            quitf(_wa, "Contestant's output is not a valid topological order");
        }
        quitf(_ok, "Valid topological order");
    }
}

int main(int argc, char *argv[]) {
#ifdef THEMIS
    registerTestlibThemis("CLASSSCH.inp", "CLASSSCH.out");
#else
    registerTestlibCmd(argc, argv);
#endif
    readInput();
    readOutput();
    return 0;
}
