#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
#define WA "Wrong answer."
#define WO WA" Wrong output format!"
#define CO "Correct Answer!"

void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf(WO"\n");
    judge_message(CO"\n");
}

const int N = 2005;
int n;
string s[N];

bool check(istream &inf, istream &ansf, istream &outf, feedback_function waf) {
    inf >> n;
    for (int i = 1; i <= 2 * n + 2; i++) {
        inf >> s[i];
        s[i] = " " + s[i];
    }
    string ans;
    string out;
    ansf >> ans;
    if (!(outf >> out))
        waf(WO"\n");

    if (ans != out)
        waf(WA"\n");

    if (out == "NO") {
        OK(outf, waf);
        return 1;
    }

    int game;
    if (!(outf >> game))
        waf(WO"\n");

    if (game == 1) {
        vector<int> a(n + 1, 0);
        vector<int> b(n + 1, 0);

        for (int &e : a)
            if (!(outf >> e))
                waf(WO"\n");

        for (int &e : b)
            if (!(outf >> e))
                waf(WO"\n");

        set<int> ss;
        for (int e : a)
            ss.insert(e);
        for (int e : b)
            ss.insert(e);

        if (ss.size() != 2 * n + 2)
            waf(WA"\n");

        for (int i = 0; i <= n; i++)
            for (int j = i + 1; j <= n; j++)
                if (s[a[i]][a[j]] != '1')
                    waf(WA"\n");

        for (int i = 0; i <= n; i++)
            for (int j = i + 1; j <= n; j++)
                if (s[b[i]][b[j]] != '1')
                    waf(WA"\n");
    } else {
        vector<bool> appeared(2 * n + 4, 0);
        for (int i = 0; i < n + 1; i++) {
            int u, v;
            u = v = 0;
            if (!(outf >> u >> v))
                waf(WO"\n");

            if (appeared[u] || appeared[v])
                waf(WA"\n");

            appeared[u] = 1;
            appeared[v] = 1;

            if (s[u][v] != '1')
                waf(WA"\n");
        }
    }

    OK(outf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
