#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;

void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Phuong an hai qua toi uu!\n");
}

#define ld long double
#define ll long long

const ll maxn = 100000;
ll n,m;
ll x[maxn+1],y[maxn+1],w[maxn+1];
ll sum;
ll r;
ll par[maxn+1];
ll W;
set<ll> used;
ll find_par(ll x)
{
	if (par[x]==x) return x;
	else return par[x] = find_par(par[x]);
}
void uni(ll x,ll y)
{
	par[find_par(x)] = find_par(y);
}

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {

    inf >> n >> m;
	sum = 0;
	for (ll i=1; i<=m; i++)
	{
		inf >> x[i] >> y[i] >> w[i];
		sum+=w[i];
	}

	if (!(ouf >> r))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");

	used.clear();
	for (ll i=1; i<=r; i++)
	{
		for (ll j=1; j<=n; j++)
			par[j] = j;
		for (ll j=1; j<n; j++)
		{
			ll id;
			if (!(ouf >> id))
                waf("Sai. Du lieu ra khong dung dinh dang!\n");

			if (used.count(id))
				waf("Sai. Duong bay thu %d cap cho nhieu hon mot hang!\n", id);

			used.insert(id);
			if (id<1 or id>m)
                waf("Sai. Chi so duong bay (%d) khong dung\n", id);

			uni(x[id],y[id]);
			W+=w[id];
		}

		for (ll j=2; j<=n; j++)
            if (find_par(1)!=find_par(j))
                waf("Sai. Viec cap duong bay khong thoa cac rang buoc!\n");
	}
    judge_message("OK. Ban xung dang nhan duoc %Lf diem!\n", 100. * (ld) W / (ld) sum);
    accept_with_score(100. * (ld) W / (ld) sum);

    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
