#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;

void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Phuong an to mau duoc chap nhan!\n");
}

int n, m, k;
vector<string> h, v;
bool readAns(istream &ouf, feedback_function waf) {
    vector<vector<int> > a(n, vector<int>(m, 0));
    if (!(ouf >> a[0][0]))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");

    if (a[0][0] == -1)
        return false;

    for(int i = 0; i < n; ++i)
        for(int j = 0; j < m; ++j)
            if (i != 0 || j != 0)
                if (!(ouf >> a[i][j]))
                    waf("Sai. Du lieu ra khong dung dinh dang!\n");

    for(int i = 0; i < n; ++i)
        for(int j = 0; j < m; ++j)
            if (a[i][j] < 1 || a[i][j] > k)
                waf("Sai. Mau trong bang phai la so nguyen tu 1 den k.\n");

    int totCond = n*(m-1) + (n-1)*m;
    int satCond = 0;

    for(int i = 0; i < n; ++i)
        for(int j = 0; j < m-1; ++j)
            satCond += (a[i][j] == a[i][j+1])^(h[i][j] == 'N');
    for(int i = 0; i < n-1; ++i)
        for(int j = 0; j < m; ++j)
            satCond += (a[i][j] == a[i+1][j])^(v[i][j] == 'N');

    if (satCond*4 < totCond*3)
        waf("Sai. So rang buoc duoc thoa man nho hon 75%%!\n");

    return true;
}

bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    //Đọc từ input của test
    inf >> n >> m >> k;
	h.resize(n);
	for(int i = 0; i < n; ++i)
        inf >> h[i];

    v.resize(n-1);
    for(int i = 0; i < n-1; ++i)
        inf >> v[i];

	//Đọc từ output của test
    bool jans = readAns(ans, waf);

	//Đọc từ output của thí sinh
    bool pans = readAns(ouf, waf);

    if (jans && !pans)
        waf("Thi sinh khong tim duoc dap an, nhung ban giam khao tim duoc!\n");
    else if (!jans && pans)
        waf(":( Ban giam khao khong tim duoc dap an, nhung thi sinh tim duoc!\n");

    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
