#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
#define ld long double
#define ll long long
const ll maxn = 100;
const ll maxx = 1000000;
ll n,m,w,k,s;
ll o[maxn+1];
bool a[maxn+1][maxn+1];
ll dem,res[maxx+1],sum;

void check(istream &fin, istream &fans, istream &fout, feedback_function waf) {
    fin >> n >> m >> w >> k >> s;
	for (ll i=1; i<=n; i++)
        fin >> o[i];
	memset(a,false,sizeof(a));
	for (ll i=1; i<=m; i++)
	{
		ll x,y;
		fin >> x >> y;
		a[x][y]=true;
		a[y][x]=true;
	}
	dem=1;
	while (fout >> res[dem]) dem++;
        dem--;
	if (res[1]!=w)
        waf("Wrong anser!");
	if (res[dem]!=k)
        waf("Wrong anser!");
	for (ll i=1; i<dem; i++)
	if (!a[res[i]][res[i+1]])
        waf("Wrong anser!");
	sum=0;
	for (ll i=1; i<=dem; i++)
	sum+=o[res[i]];
	if (sum!=s)
        waf("Wrong anser!");

    judge_message("Correct!\n");
    accept();
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
}
