from functools import wraps
import sys
import codecs

if sys.stderr.encoding != 'UTF-8':
	sys.stderr = codecs.getwriter('utf-8')(sys.stderr.buffer, 'strict')

def msg(p, s):
	print(p)
	sys.stderr.write(s)

def wrong(s):
	msg(0, f"Wrong answer. {s}!\n")
	exit(0)

def ok(s):
	msg(100, f"Accepted. {s}!\n")
	exit(0)

ans = open('answer', 'r')
_as = ans.readline().strip()
if _as == "YES":
    _af = int(ans.readline().strip())

ouf = open("user_out", "r")
_os = [x.strip() for x in ouf.readlines()]

if _os[0] == "NO":
    if _as == "YES":
        wrong("Đáp án: YES, Bạn: NO")
    ok(u"Ơ mây zing, gút chóp em. Không có cách phân việc hợp lý")
else:
    inf = open("input", 'r')
    m, n = [int(x) for x in inf.readline().strip().split()]

    if len(_os) != n + 2:
        wrong(f"Đáp án của bạn là YES nên Kết quả phải có {n + 2} dòng")
    
    t = int(_os[1])
    if _as == "YES" and t > _af:
        wrong(f"Thời gian chưa tối ưu. Đáp án: {_af}, Bạn: {t}")
    
    A = [[0 for i in range(m + 1)] for _ in range(n + 1)]
    V = [0] * (m + 1)

    for i in range(1, n + 1):
        jobs = [int(x) for x in inf.readline().strip().split()][:-1]
        for x in jobs:
            if x > 0:
                A[i][x] = 1

    for i in range(1, n + 1):
        jobs = [int(x) for x in _os[i + 1].split()][:-1]
        if len(jobs) > t:
            wrong(f"Số công việc phân cho người thứ {i} nhiều hơn thời hạn hoàn thành")
        for x in jobs:
            if x < 1 or x > m:
                wrong(f"Không có công việc {x}")
            if V[x] != 0:
                wrong(f"Công việc {x} được phân công cho nhiều người thực hiện")
            V[x] = i
            if A[i][x] != 1:
                wrong(f"Người thứ {i} không thể thực hiện công việc {x}")
    for v in range(1, m + 1):
        if V[i] == 0:
            wrong(f"Công việc {v} chưa được phân công cho người nào thực hiện")

ok(u"Ơ mây zing, gút chóp em")