import sys
import codecs

if sys.stderr.encoding != 'UTF-8':
	sys.stderr = codecs.getwriter('utf-8')(sys.stderr.buffer, 'strict')

def msg(p, s):
	print(p)
	sys.stderr.write(s)

def wrong(s):
	msg(0, f"Wrong answer. {s}!\n")
	exit(0)

def ok(s):
	msg(100, f"Accepted. {s}!\n")
	exit(0)

ans = open('answer', 'r')
ag = int(ans.readline().strip())

ouf = open("user_out", "r")

og = int(ouf.readline().strip())

if og > ag:
    wrong(f"Kết quả chưa tối ưu. Đáp án {ag} nhóm, Bạn: {og} nhóm")
else:
    inf = open("input", 'r')
    lines = [line.strip() for line in inf.readlines()]
    n, k = [int(x) for x in lines[0].split()]
    group = {}
    for i in range(1, n + 1, 1):
        group[i] = 0

    A = [[0 for i in range(n + 1)] for _ in range(n + 1)]
    for i in range(1, n, 1):
        for j in range(i + 1, n + 1, 1):
            if (lines[i][:k] == lines[j][:k] or lines[i][-k:]==lines[j][-k:]):
                A[i][j] = 1
                A[j][i] = 1

    for g in range(1, og + 1):
        x = [int(y) for y in ouf.readline().strip().split()]
        qi = x[0]
        if len(x) != 1 + qi:
            wrong(f"Nhóm {g} chưa đúng")
        for i in range(1, qi + 1):
            if group[x[i]] != 0:
                wrong(f"Nhóm {g} chưa đúng")
            group[x[i]] = g
            for j in range(i + 1, qi + 1):
                if A[x[i]][x[j]] != 1:
                    wrong(f"Nhóm {g} chưa đúng")

ok(u"Ơ mây zing, gút chúp em")