import sys
import codecs

if sys.stderr.encoding != 'UTF-8':
	sys.stderr = codecs.getwriter('utf-8')(sys.stderr.buffer, 'strict')

def msg(p, s):
	print(p)
	sys.stderr.write(s)

def wrong(s):
	msg(0, f"Wrong answer. {s}!\n")
	exit(0)

def ok(s):
	msg(100, f"Accepted. {s}!\n")
	exit(0)

ans = open('answer', 'r')
_as = ans.readline().strip()

ouf = open("user_out", "r")
_os = ouf.readline().strip()

if _os == "Impossible":
    if _as != "Impossible":
        wrong(u"Đáp án: YES, bạn: Impossible")
    else:
        ok(u"Không có cách tô màu thỏa mãn")
else:
    for x in _os:
        if x not in 'RGB':
            wrong(u'Màu sử dụng không đúng')

    inf = open("input", 'r')
    n, m = [int(x) for x in inf.readline().strip().split()]
    if len(_os) != n:
        wrong(u"Chuỗi mô tả màu chưa đúng")

    s = inf.readline().strip()
    for i in range(n):
        if s[i] == _os[i]:
            wrong(u'Màu sử dụng không đúng')

    for _ in range(m):
        u, v = [int(x) for x in inf.readline().strip().split()]
        if _os[u - 1] == _os[v - 1]:
            wrong(u"Cách tô màu chưa đúng")

ok(u"Ơ mây zing, gút chúp em")