#include <cassert>
#include <cstdio>
#include <string>
using namespace std;

inline void writeScore(int x)
{
	FILE * scr = fopen("score.txt", "w");
	fprintf(scr, "%d\n", x);
	fclose(scr);
	return ;
}

int main()
{
	FILE * fin = fopen("input", "r");
	char secret[1000];
	fscanf(fin, "%s", secret);
	puts(secret);
	int q;
	fscanf(fin, "%d", &q);
	printf("%d\n", q);
	for (int i = 1; i <= q; i++)
	{
		int k; long long x;
		fscanf(fin, "%d%lld", &k, &x);
		printf("%d %lld\n", k, x);
		for (int j = 1; j <= k; j++)
		{
			long long a;
			fscanf(fin, "%lld", &a);
			printf("%lld%c", a, j == k ? '\n' : ' ');
		}
	}
	fflush(stdout);
	fclose(fin);

	char out_secret[1000];
	FILE * fans = fopen("answer", "r");

	fscanf(fans, "%s", out_secret);
	if (scanf("%s", secret) != 1)
	{
		writeScore(-1);
		fprintf(stderr, "Invaild interaction | Invaild output token");
		return 0;
	}

	if (string(secret) != string(out_secret))
	{
		writeScore(-1);
		fprintf(stderr, "Invaild interaction | Invaild output token");
		return 0;
	}

	char verdict[1000], out_verdict[1000];

	fscanf(fans, "%s", out_verdict);
	if (scanf("%s", verdict) != 1)
	{
		writeScore(-1);
		fprintf(stderr, "Invaild interaction | Invaild library status");
		return 0;
	}

	if (string(verdict) != "OK")
	{
		writeScore(-1);
		fprintf(stderr, "Invaild interaction | Invaild input token");
		return 0;
	}

	for (int i = 1; i <= q; i++)
	{
		long long pans, jans;
		fscanf(fans, "%lld", &jans);
		if (scanf("%lld", &pans) != 1)
		{
			writeScore(-1);
			fprintf(stderr, "Invaild interaction | No answer at Test #%d", i);
			return 0;
		}

		if (pans != jans)
		{
			writeScore(0);
			fprintf(stderr, "Wrong answer | Wrong answer at Test #%d", i);
			return 0;
		}
	}

	writeScore(100);
	fprintf(stderr, "Accept | OK");
	fclose(fans);
	return 0;
}

