import sys
import codecs

if sys.stderr.encoding != 'UTF-8':
	sys.stderr = codecs.getwriter('utf-8')(sys.stderr.buffer, 'strict')

def msg(p, s):
	print(p)
	sys.stderr.write(s)

def wrong(s):
	msg(0, f"Wrong answer. {s}!\n")
	exit(0)

def ok(s):
	msg(100, f"Accepted. {s}!\n")
	exit(0)

ans = open('answer', 'r')
a = [int(x) for x in ans.readline().split()]

ouf = open("user_out", "r")
b = [int(x) for x in ouf.readline().split()]

if len(b) == 0:
	wrong(u"Không có kết quả")

if len(b) > 2:
	wrong(u"Sai định dạng dữ liệu ra")

if b[0] != a[0]:
	wrong(u"Sai giá trị nhỏ nhất")

if len(b) == 1:
	msg(50, u"Đúng một phần. Bạn chỉ trả lời giá trị nhỏ nhất")

if a[1] == b[1]:
	ok(u"Ơ mây zing, gút chúp em")
else:
	msg(50, u"Đúng một phần. Bạn chỉ trả lời giá trị nhỏ nhất")