#include <fstream>
#include <iostream>
#include <string>
#include <vector>
#include <cmath>
#include <cstdlib>
using namespace std;

vector<int> primes;
bool isPrime[5005];

void init() {
    for (int i = 2; i <= 5000; i++) {
        isPrime[i] = true;
        for (int j = 2; j * j <= i; j++) if (i % j == 0) {
            isPrime[i] = false;
            break;
        }
        if (isPrime[i]) primes.push_back(i);
    }
}

void write(string name, vector<int> a) {

    for (int i = 0; i < a.size(); i++)
        if (a[i] < 2 || a[i] > 5000) {
            cout << name << ": out of bound" << endl;
            return;
        }
    
    for (int i = 0; i < a.size(); i++)
        for (int j = i + 1; j < a.size(); j++) if (a[i] == a[j]) {
            cout << name << ": duplicate" << endl;
            return;
        }
    
    system(("mkdir " + name).c_str());
    ofstream f((name + "/coprime.inp").c_str());
    
    for (int i = 0; i < a.size(); i++) {
        int u = rand() % a.size();
        int v = rand() % a.size();
        swap(a[u], a[v]);
    }
    
    f << a.size() << endl;
    for (int i = 0; i < a.size(); i++) f << a[i] << endl;
    f.close();
    
    cout << name << ": done " << a.size() << endl;
    
    system(("time ./coprime <" + name + "/coprime.inp").c_str());
    system(("cat " + name + "/coprime.out").c_str());
//    system(("time ./coprime <" + name + "/coprime.inp >" + name + "/coprime.out").c_str());
}

void gen25(string name, int max) {
    vector<int> a;
    for (int i = 2; i <= max; i++) if (rand() % 4 == 0) a.push_back(i);
    write(name, a);
}

void gen50(string name, int max) {
    vector<int> a;
    for (int i = 2; i <= max; i++) if (rand() % 2 == 0) a.push_back(i);
    write(name, a);
}

void gen75(string name, int max) {
    vector<int> a;
    for (int i = 2; i <= max; i++) if (rand() % 4 != 0) a.push_back(i);
    write(name, a);
}

void genPrimes(string name, int max) {
    vector<int> a;
    for (int i = 2; i <= max; i++) if (isPrime[i]) {
        a.push_back(i);
        int ii = i * i;
        while (ii <= 5000) {
            a.push_back(ii);
            ii *= i;
        }
    }
    write(name, a);
}

void genNoPrime(string name, int max) {
    vector<int> a;
    for (int i = 2; i <= max; i++) if (!isPrime[i]) a.push_back(i);
    write(name, a);
}

void gen2Primes(string name, int max) {
    vector<int> a;
    for (int i = 0; i < primes.size(); i++) {
        for (int j = i + 1; j < primes.size(); j++) {
            for (int u = 0; u <= 1; u++) {
                for (int v = 0; v <= 1; v++) {
                    int x = primes[i] * primes[j];
                    if (u) x *= primes[i];
                    if (v) x *= primes[j];
                    if (2 <= x && x <= max) a.push_back(x);
                }
            }
        }
    }
    for (int i = 2; i <= max; i++) if (isPrime[i] && rand() % 10 == 0) a.push_back(i);
    write(name, a);
}

void gen3Primes(string name, int max) {
    vector<int> a;
    for (int i = 0; i < primes.size(); i++) {
        for (int j = i + 1; j < primes.size(); j++) {
            for (int u = 0; u <= 1; u++) {
                for (int v = 0; v <= 1; v++) {
                    int x = primes[i] * primes[j];
                    if (u) x *= primes[i];
                    if (v) x *= primes[j];
                    if (2 <= x && x <= max) a.push_back(x);
                }
            }
        }
    }
    for (int i = 0; i < primes.size(); i++) {
        for (int j = i + 1; j < primes.size(); j++) {
            for (int k = j + 1; k < primes.size(); k++) {
                long long x = 1LL * primes[i] * primes[j] * primes[k];
                if (2 <= x && x <= max) a.push_back(x);
            }
        }
    }
    for (int i = 2; i <= max; i++) if (isPrime[i] && rand() % 10 == 0) a.push_back(i);
    write(name, a);
}

void genFull(string name, int max) {
    vector<int> a;
    for (int i = 2; i <= max; i++) a.push_back(i);
    write(name, a);
}

int main() {
    init();
    srand(12);
    
    //sub1
    gen50       ("test01", 10);
    gen50       ("test02", 20);
    genPrimes   ("test03", 10);
    genNoPrime  ("test04", 20);
    genFull     ("test05", 20);
    
    //sub2
    gen25       ("test06", 75);
    gen50       ("test07", 80);
    gen75       ("test08", 85);
    gen25       ("test09", 90);
    gen50       ("test10", 95);
    gen75       ("test11", 100);
    genPrimes   ("test12", 67);
    genNoPrime  ("test13", 68);
    genPrimes   ("test14", 71);
    genNoPrime  ("test15", 72);
    genPrimes   ("test16", 100);
    genNoPrime  ("test17", 100);
    
    gen2Primes  ("test18", 100);
    gen3Primes  ("test19", 100);
    genFull     ("test20", 100);
    
    //sub3
    gen25       ("test21", 1000);
    gen50       ("test22", 2000);
    gen75       ("test23", 3000);
    gen25       ("test24", 5000);
    gen50       ("test25", 5000);
    gen75       ("test26", 5000);

    genPrimes   ("test27", 2345);
    genNoPrime  ("test28", 2345);
    genPrimes   ("test29", 5000);
    genNoPrime  ("test30", 5000);

    gen2Primes  ("test31", 4567);
    gen3Primes  ("test32", 4567);
    genFull     ("test33", 5000);
    gen2Primes  ("test34", 5000);
    gen3Primes  ("test35", 5000);

    return 0;
}
