#include <iostream>
#include <fstream>
#include <string>
#include <vector>
#include <cmath>
#include <cstdlib>
using namespace std;

void write(string name, vector<int> a, int L, int R) {
    
    for (int i = 0; i < a.size(); i++)
        if (a[i] < 0 || a[i] > 1000) {
            cout << name << ": out of bound" << endl;
            return;
        }

    if (L < 0 || L > 1000) {
        cout << name << ": out of bound" << endl;
        return;
    }

    if (R < 0 || R > 1000) {
        cout << name << ": out of bound" << endl;
        return;
    }
    
    if (L > R) {
        cout << name << ": out of bound" << endl;
        return;
    }
    
    system(("mkdir " + name).c_str());
    ofstream f((name + "/bit.inp").c_str());
    
    for (int i = 0; i < a.size(); i++) {
        int u = rand() % a.size();
        int v = rand() % a.size();
        swap(a[u], a[v]);
    }
    
    f << a.size() << " " << L << " " << R << endl;
    for (int i = 0; i < a.size(); i++) f << (i == 0 ? "" : " ") << a[i];
    f << endl;
    f.close();
    
    cout << name << ": done " << a.size() << endl;
    
    system(("./bit <" + name + "/bit.inp >" + name + "/bit.out").c_str());
//    system(("./bit <" + name + "/bit.inp").c_str());
//    system(("./trau <" + name + "/bit.inp").c_str());
}

void gen(string name, int n, int L, int R, int vMin = 0, int vMax = 1000) {
    vector<int> a;
    for (int i = 0; i < n; i++) {
        a.push_back(vMin + rand() % (vMax - vMin + 1));
    }
    write(name, a, L, R);
}

void db1(string name, int n, int L, int R, int vMin = 0, int vMax = 1000) {
    vector<int> a;
    for (int i = 0; i < n/4; i++) {
        a.push_back(512);
        a.push_back(511);
        a.push_back(vMin + rand() % (vMax - vMin + 1));
        a.push_back(vMin + rand() % (vMax - vMin + 1));
    }
    write(name, a, L, R);
}

int main() {
    db1("test01", 4, 0, 1000);
    gen("test02", 4, 0, 1000);
    gen("test03", 5, 0, 1000);
    gen("test04", 10, 0, 1000);
    gen("test05", 20, 0, 1000);
    gen("test06", 30, 0, 1000);
    gen("test07", 40, 0, 1000);

    gen("test08", 150, 123, 123);
    gen("test09", 200, 234, 234);
    gen("test10", 200, 512, 512);
    gen("test11", 350, 511, 511);
    gen("test12", 350, 1000, 1000);
    gen("test13", 400, 0, 0);
    db1("test14", 400, 1, 1);
    
    gen("test15", 150, 100, 200);
    gen("test16", 200, 234, 432);
    gen("test17", 200, 511, 512);
    gen("test18", 350, 52, 125);
    gen("test19", 350, 110, 1000);
    gen("test20", 400, 0, 108);
    db1("test21", 400, 11, 777);

    gen("test22", 1500, 123, 123);
    gen("test23", 2000, 234, 234);
    gen("test24", 2000, 512, 512);
    gen("test25", 3500, 511, 511);
    gen("test26", 3500, 1000, 1000);
    gen("test27", 4000, 0, 0);
    db1("test28", 4000, 1, 1);

    gen("test29", 1500, 123, 861);
    gen("test30", 2000, 234, 999);
    gen("test31", 2000, 64, 512);
    gen("test32", 3500, 127, 511);
    gen("test33", 3500, 100, 1000);
    gen("test34", 4000, 321, 350);
    db1("test35", 4000, 777, 787);

    return 0;
}