#include <iostream>
#include <fstream>
#include <cmath>
#include <cstdlib>

using namespace std;

double randf() {
    double base = 0.1;
    double res = 0;
    for (int i = 0; i < 20; i++) {
        res += base * (rand() % 10);
        base /= 10;
    }
    return res;
}

int randi(int V) {
    return (int)floor(V * randf());
}

void gen(string name, int m, int n, int t) {
    system(("mkdir " + name).c_str());
    ofstream f((name + "/equa.inp").c_str());
    
    f << t << endl;
    for (int i = 0; i < t; i++) {
        int a = randi(m) + 1;
        int b = randi(n) + 1;
        f << a << " " << b << endl;
    }
    
    f.close();

    system(("time ./minhTH <" + name + "/equa.inp >" + name + "/equa.out").c_str());
    
    system(("time ./minhTH <" + name + "/equa.inp >minhTH.out").c_str());
    system(("time ./tuanSP <" + name + "/equa.inp >tuanSP.out").c_str());
    system(("time ./khanhHP <" + name + "/equa.inp >khanhHP.out").c_str());
    
    system("diff minhTH.out tuanSP.out");
    system("diff minhTH.out khanhHP.out");
    system("diff khanhHP.out tuanSP.out");
}

void gDB(string name, int a, int b, int t) {
    system(("mkdir " + name).c_str());
    ofstream f((name + "/equa.inp").c_str());
    
    f << t << endl;
    for (int i = 0; i < t; i++) {
        f << a << " " << b << endl;
    }
    
    f.close();
    
    system(("time ./minhTH <" + name + "/equa.inp >" + name + "/equa.out").c_str());

    system(("time ./minhTH <" + name + "/equa.inp >minhTH.out").c_str());
    system(("time ./tuanSP <" + name + "/equa.inp >tuanSP.out").c_str());
    system(("time ./khanhHP <" + name + "/equa.inp >khanhHP.out").c_str());
    
    system("diff minhTH.out tuanSP.out");
    system("diff minhTH.out khanhHP.out");
    system("diff khanhHP.out tuanSP.out");
    
}


int main() {
    ios_base::sync_with_stdio(false);

    gDB("test01", 1, 1, 1);
    gen("test02", 20, 20, 1);
    gen("test03", 50, 50, 1);
    gen("test04", 40, 40, 1);
    gDB("test05", 50, 50, 1);

    gen("test06", 1000, 1000, 10);
    gen("test07", 1000, 1000, 10);
    gen("test08", 1000, 1000, 10);
    gen("test09", 1000, 1000, 10);
    gen("test10", 1000, 1000, 10);

    gen("test11", 100000, 100000, 100);
    gen("test12", 1000000, 1000000, 100);
    gen("test13", 10000000, 10000000, 100);
    gen("test14", 100000000, 100000000, 100);
    gen("test15", 1000000000, 1000000000, 100);
    
    gen("test16", 600000, 600000, 600000);
    gen("test17", 700000, 700000, 700000);
    gen("test18", 800000, 800000, 800000);
    gen("test19", 900000, 900000, 900000);
    gen("test20", 1000000, 1000000, 1000000);
}
