#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Phuong an phan may thuc tap toi uu!\n");
}

#define nmax 21002
int n, m, x[nmax], y[nmax], res = 0, as = 0, cnt = 0, j;
bool c[nmax];
bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    inf >> n >> m;
    for (int i = 1; i <= n; i++)
        inf >> x[i];
    for (int i = 1; i <= m; i++)
        inf >> y[i];

    ans >> res;
    if (!(ouf >> as))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");

    if (as < res)
        waf("Sai. Phuong an phan may thuc tap chua toi uu!\n");

    memset(c, 0, sizeof c);
    for (int i = 1; i <= n; i++) {
        if (!(ouf >> j))
            waf("Sai. Du lieu ra khong dung dinh dang!\n");
        if (j < 0 || j > m)
            waf("Sai. Phuong an phan phong cho lop %d khong dung!\n", i);

        if (j) {
            cnt++;
            if (c[j])
                waf("Sai. Phong %d da su dung!\n", j);
            c[j] = 1;
            if (x[i] >= y[j])
                waf("Sai. Phong %d phan cho lop %d khong du may!\n", j, i);
        }
    }
    if (cnt != as)
        waf("Sai. So luong lop duoc phan phong thuc tap khong dung!\n");

    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
