#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <bits/stdc++.h>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;
#define nmax 21
int m, n, a[nmax][nmax];
bool r[nmax], c[nmax];
int as, os;
void OK(istream &ouf, feedback_function waf) {
    string t;
    if (ouf >> t)
        waf("Sai. Du lieu ra khong dung dinh dang.\n");
    judge_message("OK. Dap an duoc chap nhan!\n");
}
bool check(istream &inf, istream &ans, istream &ouf, feedback_function waf) {
    ans >> as;
    if (!(ouf >> os))
        waf("Sai. Du lieu ra khong dung dinh dang!\n");
    if (os < as)
        waf("Sai. Kich thuoc ma tran du lại khong dung!\n");

    inf >> m >> n;
    for (int i = 1; i <= m; i++)
        for (int j = 1; j <= n; j++)
            inf >> a[i][j];

    memset(r, 0, sizeof r);
    memset(c, 0, sizeof c);
    for (int x, i = 0; i < m - os; i++) {
        if (!(ouf >> x))
            waf("Sai. Du lieu ra khong dung dinh dang!\n");
        if (x < 1 || x > m)
            waf("Sai. Hang %d can xoa khong dung!\n", x);
        if (r[x])
            waf("Sai. Hang %d da xoa roi!\n", x);
        r[x] = 1;
    }

    for (int x, i = 0; i < n - os; i++) {
        if (!(ouf >> x))
            waf("Sai. Du lieu ra khong dung dinh dang!\n");
        if (x < 1 || x > n)
            waf("Sai. Cot %d can xoa khong dung!\n", x);
        if (c[x])
            waf("Sai. Cot %d da xoa roi!\n", x);
        c[x] = 1;
    }
    int i = 0;
    for (int y = 1; y <= m; y++)
        if (!r[y]) {
            i++;
            int j = 0;
            for (int x = 1; x <= n; x++)
                if (!c[x]) {
                    j++;
                    if (a[y][x] != (i == j))
                        waf("Sai. Ma tran sau khi xoa khong phai ma tran don vi!\n");
                }
        }
    OK(ouf, waf);
    return 1;
}
#endif

int main(void) {
    init_io();
    check(judge_in, judge_ans, user_out, wrong_answer);
    accept();
}
