#include"testlib.h"

#include<bits/stdc++.h>
#define FOR(i,a,b) for (int i=(a),_b=(b);i<=_b;i=i+1)
#define FORD(i,b,a) for (int i=(b),_a=(a);i>=_a;i=i-1)
#define REP(i,n) for (int i=0,_n=(n);i<_n;i=i+1)
#define FORE(i,v) for (__typeof((v).begin()) i=(v).begin();i!=(v).end();i++)
#define ALL(v) (v).begin(),(v).end()
#define fi   first
#define se   second
#define MASK(i) (1LL<<(i))
#define BIT(x,i) (((x)>>(i))&1)
#define div   ___div
#define next   ___next
#define prev   ___prev
#define left   ___left
#define right   ___right
#define __builtin_popcount __builtin_popcountll
using namespace std;
template<class X,class Y>
    void minimize(X &x,const Y &y) {
        if (x>y) x=y;
    }
template<class X,class Y>
    void maximize(X &x,const Y &y) {
        if (x<y) x=y;
    }
template<class T>
    T Abs(const T &x) {
        return (x<0?-x:x);
    }

/* Author: Van Hanh Pham - skyvn97 */

/** END OF TEMPLATE - ACTUAL SOLUTION COMES HERE **/
const string name = "SimpleGraph";
const string colors[] = {"PURPLE", "ORANGE"};
const string yes = "YES";
const string no = "NO";

struct Edge {
    int u, v, color;

    Edge() {
        u = v = 0;
    }
    Edge(int _u, int _v) {
        u = _u; v = _v; color = -1;
    }

    int other(int x) const {
        assert(u == x || v == x);
        return u ^ v ^ x;
    }
};

#define MAX   100100

Edge edges[MAX];
vector<int> adj[MAX];
pair<int, int> pairs[MAX];
int high[MAX];
int numNode, numEdge, numPair;

void loadTree(void) {
    inf.readInt(1, 6);

    numNode = inf.readInt();
    numEdge = inf.readInt(numNode - 1, numNode - 1);
    numPair = inf.readInt();

    FOR(i, 1, numEdge) {
        int u = inf.readInt();
        int v = inf.readInt();
        int c = inf.readInt();
        edges[i] = Edge(u, v);
        adj[u].push_back(i);
        adj[v].push_back(i);
    }

    FOR(i, 1, numPair) {
        pairs[i].fi = inf.readInt();
        pairs[i].se = inf.readInt();
    }
}

void dfs(int u, int par) {
    FORE(it, adj[u]) {
        int v = edges[*it].other(u);
        if (v == par) continue;
        high[v] = high[u] + edges[*it].color;
        dfs(v, u);
    }
}

string readLine(InStream &stream, const string &s, const string &t, const string &varName) {
    string input = stream.readLine();
    if (input != s && input != t) stream.quitf(_pe, "%s should be either %s or %s\n",
        varName.c_str(), s.c_str(), t.c_str());
    return input;
}

bool checkAnswer(InStream &stream) {
    memset(high, 0, sizeof high);

    if (readLine(stream, yes, no, "Answer") == no) return false;
    FOR(i, 1, numEdge) edges[i].color = readLine(stream, colors[0], colors[1], "Edge's color") == colors[0] ? 0 : 1;

    dfs(1, -1);
    FOR(i, 1, numPair) {
        int u = pairs[i].fi;
        int v = pairs[i].se;
        if (high[u] % 2 == high[v] % 2)
            stream.quitf(_wa, "Pair #%d: Path from %d to %d has an even number of ORANGE edge", i, u, v);
    }
    return true;
}

void process(void) {
    bool exp = checkAnswer(ans);
    bool res = checkAnswer(ouf);

    if (exp) {
        if (!res) quitf(_wa, "Contestant thinks that solution does not exist, but it does!");
        else quitf(_ok, "Correct solution. (%d nodes and %d pairs)", numNode, numPair);
    } else {
        if (!res) quitf(_ok, "Solution does not exist.");
        else quitf(_fail, "Jury thinks that solution does not exist, but it does!");
    }
}

int main(int c, char **v) {
#ifdef THEMIS
    registerTestlibThemis(name + ".inp", name + ".out");
#else
    registerTestlibCmd(c, v);
#endif // THEMIS
    loadTree();
    process();
    return 0;
}

/*** LOOK AT MY CODE. MY CODE IS AMAZING :D ***/
