#include <vector>
#include <algorithm>
#include <cstring>

#define nmax 100001
int a[nmax], b[nmax], n, d_ans, d = 0;
bool f[nmax], g[nmax];

#ifndef __EMITTED_VALIDATE_H
#define __EMITTED_VALIDATE_H

#include <sys/stat.h>
#include <cassert>
#include <cstdarg>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <sstream>

typedef void (*feedback_function)(const char*, ...);

const int EXITCODE_AC = 0;
const int EXITCODE_WA = 0;

// declare a constant to be used as user_out.
const std::string FILENAME_USER_OUTPUT = "user_out";
// declare a constant to be used as input.
const std::string FILENAME_INPUT = "input";

#define USAGE "./%s\n"
// we have to define USAGE as dummy because we don't want to modify the lib. too much.

std::ifstream judge_in, judge_ans;
// another ifstream must be used for user_out;
std::ifstream user_out;

char *feedbackdir = NULL;

void vreport_feedback(const char* msg, va_list pvar) {
    assert(stderr);
    vfprintf(stderr, msg, pvar);
}

void report_feedback(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_message(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
}

void judge_error(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    assert(0);
}

// cleaning up.
void cleanup() {
    fflush(stderr);
    fclose(stderr);
    fflush(stdout);
    fclose(stdout);
    judge_in.close();
    user_out.close();
}

// write another function ``scoring()`` for ac or wa.
void scoring(double score) {
    fprintf(stdout, "%.f", score + 1e-9);
}

void accept() {
    scoring(100.);
    cleanup();
    exit(EXITCODE_AC);
}

void accept_with_score(double scorevalue) {
    scoring(scorevalue);
    cleanup();
    exit(EXITCODE_AC);
}

void wrong_answer(const char* msg, ...) {
    va_list pvar;
    va_start(pvar, msg);
    vreport_feedback(msg, pvar);
    scoring(0.);
    cleanup();
    exit(EXITCODE_WA);
}

void init_io() {
    judge_in.open(FILENAME_INPUT, std::ios_base::in);
    if(judge_in.fail()) {
        judge_error("failed to open input file.\n");
    }
    user_out.open(FILENAME_USER_OUTPUT, std::ios_base::in);
    if(user_out.fail()) {
        judge_error("failed to open user output file.\n");
    }
    judge_ans.open("answer", std::ios_base::in);
    if(judge_ans.fail()) {
        judge_error("failed to open answer file.\n");
    }
}
using namespace std;

void read_input(istream &in) {
    in >> n;
    for (int i = 1; i <= n; i++)
        in >> a[i];
    for (int i = 1; i <= n; i++)
        in >> b[i];
}

void read_ans(istream &sol, feedback_function feedback) {
    if (!(sol >> d_ans)) {
        feedback("Answer file seems to be empty");
    }
}

void read_sol(istream &sol, feedback_function feedback) {
    memset(f, 0, sizeof f);
    memset(g, 0, sizeof g);
    for (int x, y, i = 1; i <= n; i++) {
        if (!(sol >> x >> y))
            feedback("Khong thay cap ngua dua thu %d", i);
        if (!(x >= 1 && x <= n && y >= 1 && y <= n))
            feedback("Cap ngua dua thu %d khong hop le (%d vs %d)", i, x, y);
        if (f[x])
            feedback("Ngua thu %d cua Ton Tan da duoc su dung", x);
        if (g[y])
            feedback("Ngua so %d cua Vua Te da duoc su dung", y);
        f[x] = g[y] = 1;
        if (a[x] > b[y]) d++;
        else if (a[x] < b[y]) d--;
    }
    string S;
    if (sol >> S)
        feedback("Trailing output");
}
#endif

int main(void) {
    init_io();
    read_input(judge_in);
    read_ans(judge_ans, judge_error);
    read_sol(user_out, wrong_answer);

    if (d < d_ans)
        wrong_answer("Hieu diem so cua Ton Tan va Vua Te tot nhat la %d, ban tra loi la :%d", d_ans, d);

    accept();
}
